<?php

namespace Modules\Recruit\Traits;

use Illuminate\Support\Facades\Config;
use Modules\Zoom\Entities\ZoomSetting as EntitiesZoomSetting;

trait ZoomSettings
{
    public function setZoomConfigs()
    {
        if (module_enabled('Zoom')) {
            $settings = EntitiesZoomSetting::first();
            $key = ($settings->api_key) ?: env('ZOOM_CLIENT_KEY');
            $apiSecret = ($settings->secret_key) ?: env('ZOOM_CLIENT_SECRET');

            Config::set('zoom.api_key', $key);
            Config::set('zoom.api_secret', $apiSecret);
        }
    }
}
