<?php $__env->startSection('content'); ?>
    <section class="section bg-img" id="section-contact" style="background-image: url(<?php echo e(asset('front/img/bg-cup.jpg')); ?>)"
        data-overlay="8">
        <div class="container">
            <?php if(session('company_approval_pending')): ?>
                <div class="alert alert-success">
                    <?php echo app('translator')->get('superadmin.signUpApprovalPending'); ?>
                </div>
            <?php else: ?>
                <?php if($registrationStatus->registration_open == 1 && $global->enable_register == true): ?>
                    <div class="row gap-y">

                        <div class="col-12 col-md-8 offset-md-3 form-section">

                            <?php echo Form::open(['id' => 'register', 'method' => 'POST']); ?>

                            <div class="col-12 col-md-10 bg-white px-30 py-45 rounded">
                                <h2 class="text-center m-b-15"><?php echo app('translator')->get('app.signUp'); ?></h2>
                                <p id="alert"></p>
                                <div id="form-box">
                                    <div class="row">
                                        <div class="col-12">
                                            <?php if(module_enabled('Subdomain')): ?>
                                                <div class="form-group">
                                                    <div class="sub-domain">
                                                        <input type="text" class="form-control"
                                                            placeholder="your-login-url" name="sub_domain">
                                                        <?php if(function_exists('get_domain')): ?>
                                                            <span class="domain-text">.<?php echo e(getDomain()); ?></span>
                                                        <?php else: ?>
                                                            <span class="domain-text">.<?php echo e($_SERVER['SERVER_NAME']); ?></span>
                                                        <?php endif; ?>
                                                    </div>
                                                </div>
                                            <?php endif; ?>
                                            <div class="form-group">
                                                <input type="text" class="form-control" id="company_name"
                                                    name="company_name"
                                                    placeholder="<?php echo e(__('modules.client.companyName')); ?>">
                                            </div>
                                        </div>
                                    </div>

                                    <div class="row">
                                        <div class="col-6">
                                            <div class="form-group">
                                                <input class="form-control form-control-lg" type="text" id="name"
                                                    name="name" placeholder="<?php echo e(__('modules.profile.yourName')); ?>">
                                            </div>
                                        </div>
                                        <div class="col-6">
                                            <div class="form-group">
                                                <input class="form-control form-control-lg" type="email" id="email"
                                                    name="email" placeholder="<?php echo e(__('modules.profile.yourEmail')); ?>">
                                            </div>
                                        </div>
                                        <div class="col-6">
                                            <div class="form-group">
                                                <input type="password" class="form-control form-control-lg" id="password"
                                                    name="password" placeholder="<?php echo e(__('modules.client.password')); ?>">
                                            </div>
                                        </div>
                                        <div class="col-6">
                                            <div class="form-group">
                                                <input type="password" class="form-control form-control-lg"
                                                    id="password_confirmation" name="password_confirmation"
                                                    placeholder="<?php echo e(__('app.confirmPassword')); ?>">
                                            </div>
                                        </div>

                                        <div class="col-12">
                                            <?php if($global->google_recaptcha_status == 'active' && $global->google_recaptcha_v2_status == 'active'): ?>
                                                <div class="form-group" id="captcha_container"></div>
                                                <input type="hidden" id="g_recaptcha" name="g_recaptcha">
                                            <?php endif; ?>
                                            <?php if($global->google_recaptcha_status == 'active' && $global->google_recaptcha_v3_status == 'active'): ?>
                                                <div class="form-group">
                                                    <input type="hidden" id="g_recaptcha" name="g_recaptcha">
                                                </div>
                                            <?php endif; ?>
                                        </div>

                                        <?php if($global->sign_up_terms == 'yes'): ?>
                                            <div class="col-12">
                                                <div class="form-group">
                                                    <input autocomplete="off" id="read_agreement"
                                                        name="terms_and_conditions" type="checkbox">
                                                    <label for="read_agreement"><?php echo app('translator')->get('superadmin.superadmin.acceptTerms'); ?> <a
                                                            href="<?php echo e($global->terms_link); ?>"
                                                            target="_blank"><?php echo app('translator')->get('superadmin.superadmin.termsAndCondition'); ?></a></label>
                                                </div>
                                            </div>
                                        <?php endif; ?>

                                        <div class="col-12">
                                            <button class="btn btn-lg btn-block btn-primary" type="button"
                                                id="save-form"><?php echo app('translator')->get('app.signUp'); ?></button>
                                        </div>

                                    </div>
                                </div>
                                <?php echo Form::close(); ?>

                            </div>
                        </div>
                    <?php else: ?>
                        <div class="col-12 col-md-10 bg-white px-30 py-45 rounded">
                            <p><?php echo $signUpMessage->message; ?></p>
                        </div>
                <?php endif; ?>
            <?php endif; ?>
        </div>
    </section>
<?php $__env->stopSection(); ?>
<?php $__env->startPush('footer-script'); ?>
    <script>
        $('#save-form').click(function() {


            $.easyAjax({
                url: '<?php echo e(route('front.signup.store')); ?>',
                container: '.form-section',
                type: "POST",
                data: $('#register').serialize(),
                messagePosition: "inline",
                success: function(response) {
                    if (response.status == 'success') {
                        $('#form-box').remove();
                    } else if (response.status == 'fail') {
                        <?php if($global->google_recaptcha_status): ?>
                            grecaptcha.reset();
                        <?php endif; ?>

                    }
                }
            });
            <?php if($global->google_recaptcha_status): ?>
                grecaptcha.reset();
            <?php endif; ?>
        });
    </script>
    <?php if($global->google_recaptcha_status == 'active' && $global->google_recaptcha_v2_status == 'active'): ?>
        <script src="https://www.google.com/recaptcha/api.js?onload=onloadCallback&render=explicit" async defer></script>
        <script>
            var gcv3;
            var onloadCallback = function() {
                // Renders the HTML element with id 'captcha_container' as a reCAPTCHA widget.
                // The id of the reCAPTCHA widget is assigned to 'gcv3'.
                gcv3 = grecaptcha.render('captcha_container', {
                    'sitekey': '<?php echo e($global->google_recaptcha_v2_site_key); ?>',
                    'theme': 'light',
                    'callback': function(response) {
                        if (response) {
                            $('#g_recaptcha').val(response);
                        }
                    },
                });
            };
        </script>
    <?php endif; ?>
    <?php if($global->google_recaptcha_status == 'active' && $global->google_recaptcha_v3_status == 'active'): ?>
        <script src="https://www.google.com/recaptcha/api.js?render=<?php echo e($global->google_recaptcha_v3_site_key); ?>"></script>
        <script>
            grecaptcha.ready(function() {
                grecaptcha.execute('<?php echo e($global->google_recaptcha_v3_site_key); ?>').then(function(token) {
                    // Add your logic to submit to your backend server here.
                    $('#g_recaptcha').val(token);
                });
            });
        </script>
    <?php endif; ?>
<?php $__env->stopPush(); ?>

<?php echo $__env->make('super-admin.layouts.front-app', \Illuminate\Support\Arr::except(get_defined_vars(), ['__data', '__path']))->render(); ?><?php /**PATH /home/u562907727/domains/recruitboards.com/public_html/resources/views/super-admin/front/register.blade.php ENDPATH**/ ?>