<?php

namespace Modules\Recruit\Listeners;

use App\Models\User;
use Modules\Recruit\Events\UpdateJobEvent;
use Modules\Recruit\Notifications\JobRecruiter;
use Modules\Recruit\Notifications\RemoveJobRecruiter;
use Modules\Recruit\Notifications\UpdateJob;
use Notification;

class UpdateJobListener
{
    /**
     * Create the event listener.
     *
     * @return void
     */
    public function __construct()
    {
        //
    }

    /**
     * Handle the event.
     *
     * @param  object  $event
     * @return void
     */
    public function handle(UpdateJobEvent $event)
    {
        if ($event->job->isDirty('recruiter_id')) {
            $oldJob = $event->job;
            Notification::send(User::findOrFail($oldJob->recruiter_id), new RemoveJobRecruiter($oldJob));
            Notification::send($event->job->recruiter, new JobRecruiter($event->job));
        } else {
            Notification::send($event->job->recruiter, new UpdateJob($event->job));
        }
    }
}
